/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.battery.BlockBattery;
import com.lothrazar.cyclic.block.battery.ContainerBattery;
import com.lothrazar.cyclic.block.battery.EnumBatteryPercent;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TileBattery
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final int SLOT_CHARGING_RATE = 8000;
    private Map<Direction, Boolean> poweredSides;
    CustomEnergyStorage energy = new CustomEnergyStorage(6400000, 1600000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    public static final int MAX = 6400000;
    ItemStackHandler batterySlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileBattery(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BATTERY.get(), pos, state);
        this.flowing = 0;
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileBattery e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileBattery e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        this.setPercentFilled();
        boolean isFlowing = this.getFlowing() == 1;
        this.setLitProperty(isFlowing);
        if (isFlowing) {
            this.tickCableFlow();
        }
        this.chargeSlot();
    }

    private void chargeSlot() {
        int extracted;
        int accepted;
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack slotItem = this.batterySlots.getStackInSlot(0);
        IEnergyStorage itemStackStorage = (IEnergyStorage)slotItem.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (itemStackStorage != null && (accepted = itemStackStorage.receiveEnergy(extracted = this.energy.extractEnergy(8000, true), true)) > 0) {
            this.energy.extractEnergy(accepted, false);
            itemStackStorage.receiveEnergy(accepted, false);
        }
    }

    public void setPercentFilled() {
        BlockState st = this.m_58900_();
        if (st.m_61138_(BlockBattery.PERCENT)) {
            EnumBatteryPercent previousPercent = (EnumBatteryPercent)((Object)st.m_61143_(BlockBattery.PERCENT));
            EnumBatteryPercent percent = this.calculateRoundedPercentFilled();
            if (percent != previousPercent) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)st.m_61124_(BlockBattery.PERCENT, (Comparable)((Object)percent)));
            }
        }
    }

    public EnumBatteryPercent calculateRoundedPercentFilled() {
        int percent = (int)Math.floor((double)((float)this.getEnergy() * 1.0f / 6400000.0f) * 10.0) * 10;
        if (percent >= 100) {
            return EnumBatteryPercent.ONEHUNDRED;
        }
        if (percent >= 90) {
            return EnumBatteryPercent.NINETY;
        }
        if (percent >= 80) {
            return EnumBatteryPercent.EIGHTY;
        }
        if (percent >= 60) {
            return EnumBatteryPercent.SIXTY;
        }
        if (percent >= 40) {
            return EnumBatteryPercent.FOURTY;
        }
        if (percent >= 20) {
            return EnumBatteryPercent.TWENTY;
        }
        return EnumBatteryPercent.ZERO;
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.m_128471_("flow_" + f.m_122433_()));
        }
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.batterySlots.deserializeNBT(tag.m_128469_("invbatt"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            tag.m_128379_("flow_" + f.m_122433_(), this.poweredSides.get(f).booleanValue());
        }
        tag.m_128365_("invbatt", (Tag)this.batterySlots.serializeNBT());
        tag.m_128405_("flowing", this.getFlowing());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        super.m_183515_(tag);
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerBattery(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    private void tickCableFlow() {
        Collections.shuffle(this.rawList);
        for (Integer i : this.rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveEnergy(exportToSide, 1600000);
        }
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        FLOWING,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

